//###################################################################
// GUI.cpp :  Main graphics user interface
//
// OnLButtonDown()	: Mouse left button pressed reaction
// OnLButtonUp()	: Mouse left button released reaction
// OnRButtonDown()	: Mouse right button pressed reaction
//###################################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "SpeedDomeDoc.h"
#include "SpeedDomeView.h"
#include "vfw.h"
#include "presetdlg.h"
#include "misc.h"
#include "DomePropertySheet.h"
#include "PresetPropertySheet.h"
#include "Preset.h"
#include "Sequence.h"
#include "Cruise.h"
#include "Comm.h"
#include "VideoMainCWnd.h"
#include "Dome.h"
#include "Define.h"
#include "stdio.h"
#include "GlobalVar.h"


//###################################################################
// S_LButtonChoice()
//
// Mouse left button pressed reaction
//###################################################################

void CControlDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
Flag_Polling=0;
//----------------------------------------
int				Y_CtrlID;
int				BitmapChanged=0;
UINT 			PresetNum,DomeNum,SQNum,CruiseNum;
LPTSTR			CruiseBmpName,DomeBmpName,SQBmpName,PresetBmpName;

//-- Record Point ----
G_CPoint=point;

//------------------------------------------------------------------
CSliderCtrl*	pSlider_PanSpeed;
CSliderCtrl*	pSlider_TiltSpeed;
CSliderCtrl*	pSlider_ZoomSpeed;
CSliderCtrl*	pSlider_FocusSpeed;

pSlider_PanSpeed=(CSliderCtrl* )	GetDlgItem(IDC_SLIDER_PAN_SPEED);
pSlider_TiltSpeed=(CSliderCtrl* )	GetDlgItem(IDC_SLIDER_TILT_SPEED);
pSlider_ZoomSpeed=(CSliderCtrl* )	GetDlgItem(IDC_SLIDER_ZOOM_SPEED);
pSlider_FocusSpeed=(CSliderCtrl* )	GetDlgItem(IDC_SLIDER_FOCUS_SPEED);
//------------------------------------------------------------------
HWND	hWnd_Child;	
CPoint	Y_CPoint;
POINT	Y_Point;

Y_CPoint=point;
ClientToScreen(&Y_CPoint);
		Y_Point.x=Y_CPoint.x;
		Y_Point.y=Y_CPoint.y;
hWnd_Child=::WindowFromPoint(Y_Point);
//---------------------------------------
if ( hWnd_Child != m_hWnd )
	{
	Y_CtrlID=::GetDlgCtrlID( hWnd_Child );
	G_CtrlID=Y_CtrlID;

	switch (Y_CtrlID)
		{
	case IDC_VIDEO_IN :
		if(VideoOn==0)
			hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		else
			hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUAREU) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		hPreBitmap=NULL;
		break;
	case IDC_RESET :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		//SetDlgItemText(IDC_EDIT1,"sync");
		break;
	case IDC_COM_PORT :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		break;
	//--------------------- OSD --------------------------------
	case IDC_OSD :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_OSD_VKey(4);
		break;
	case IDC_OSD_LEFT :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_OSD_VKey(2);
		break;
	case IDC_OSD_UP :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_OSD_VKey(0);
		break;
	case IDC_OSD_RIGHT :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_OSD_VKey(3);
		break;
	case IDC_OSD_DOWN :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_OSD_VKey(1);
		break;
	//--------------------- IRIS Up/Down -----------------------
	case IDC_IRIS_OPEN :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_IRISOpen();
		break;
	case IDC_IRIS_CLOSE :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		m_nZoomSpeed=pSlider_ZoomSpeed->GetPos();
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_IRISClose();
		break;
	//--------------------- Zoom in/out -----------------------
	case IDC_ZOOM_IN  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		m_nZoomSpeed=pSlider_ZoomSpeed->GetPos();
		CComm::S_COM_ZoomSpeed(m_nZoomSpeed);
		CComm::S_COM_ZoomIn();
		break;
	case IDC_ZOOM_OUT :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		m_nZoomSpeed=pSlider_ZoomSpeed->GetPos();
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_ZoomSpeed(m_nZoomSpeed);
		CComm::S_COM_ZoomOut();
		break;
	//--------------------- Focus in/out -----------------------
	case IDC_FOCUS_IN  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		m_nFocusSpeed=pSlider_FocusSpeed->GetPos();
		CComm::S_COM_FocusSpeed(m_nFocusSpeed);
		CComm::S_COM_FocusIn();
		break;
	case IDC_FOCUS_OUT :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		m_nFocusSpeed=pSlider_FocusSpeed->GetPos();
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		m_nFocusSpeed=pSlider_FocusSpeed->GetPos();
		CComm::S_COM_FocusSpeed(m_nFocusSpeed);
		CComm::S_COM_FocusOut();
		break;
	case IDC_AUTOFOCUS :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		CComm::S_COM_AutoFocus('\x0');
		break;
	case IDC_AUTOFLIP :
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_BUTTON_SQUARED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		break;
	//--------------------- Direction -------------------------
	case IDC_PAD	:
		{
		if (DomeEnable==0)		//---- If dome is disconnect then disable
			break;
		G_PadNum=PadMath(point);
		PadDraw(G_PadNum);
		if (ManualFlag==0)
			{
			CComm::S_COM_Manual();
			ManualFlag=1;
			}
		//------------------------------------------
		m_nPanSpeed=pSlider_PanSpeed->GetPos();
		m_nTiltSpeed=pSlider_TiltSpeed->GetPos();
		//------------------------------------------------------
		switch(G_PadNum)
			{
			case 1:										break;	//manual (stop)
			case 2:	CComm::S_COM_Left(m_nPanSpeed);		break;	//left
			case 3:	CComm::S_COM_Up(m_nTiltSpeed);		break;	//up
			case 4:	CComm::S_COM_Right(m_nPanSpeed);	break;	//right
			case 5:	CComm::S_COM_Down(m_nTiltSpeed);	break;	//down
			}
		}
		break;
	//--------------------- Preset ------------------------------
	case IDC_PRESET_NUM1 :
	case IDC_PRESET_NUM2 :
	case IDC_PRESET_NUM3 :
	case IDC_PRESET_NUM4 :
	case IDC_PRESET_NUM5 :
	case IDC_PRESET_NUM6 :
	case IDC_PRESET_NUM7 :
	case IDC_PRESET_NUM8 :
	case IDC_PRESET_NUM9 :
	case IDC_PRESET_NUM10:
	case IDC_PRESET_NUM11:
		{	
		if ( DomeEnable==0 )
			break;
		if (ManualFlag==0)
			{
			CComm::S_COM_Manual();
			ManualFlag=1;
			//Sleep(10);
			}
		PresetNum=CPreset::S_PresetIDToNum(Y_CtrlID,&PresetBmpName);
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),PresetBmpName );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		//
		m_nPanSpeed=pSlider_PanSpeed->GetPos();
		m_nTiltSpeed=pSlider_TiltSpeed->GetPos();
		//
		CPreset::S_GotoPresetPoint(PresetNum);
		}
		break;
	/*
	case IDC_PRESET_MORE :
		PresetNum=CPreset::S_PresetIDToNum(Y_CtrlID,&PresetBmpName);
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),PresetBmpName );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		break;
	*/
	//--------------- Dome ---------------------------------------
	case IDC_DOME_NUM1 :
	case IDC_DOME_NUM2 :
	case IDC_DOME_NUM3 :
	case IDC_DOME_NUM4 :
	case IDC_DOME_NUM5 :
	case IDC_DOME_NUM6 :
	case IDC_DOME_NUM7 :
	case IDC_DOME_NUM8 :
	case IDC_DOME_NUM9 :
		DomeNum=CDome::S_DomeIDToNum(Y_CtrlID,&DomeBmpName);
		//--- check dome on bus and suitable button is enable ---
		if ( DomeNum>DomeNumOnBus )
			break;
		if ( DomeNum<=DomeNumOnBus )
			DomeEnable=1;
		G_DomeID= DomeIDOnBus[DomeNum-1];
		G_DomeType= DomeType[DomeNum-1];
		unsigned int	Temp;
		Temp=(unsigned int)DomeIDOnBus[DomeNum-1];
		char			disp[30];
		sprintf(disp," DOME ID :%4u ",Temp);
		LED(disp);
		SendDlgItemMessage(IDC_COMM_STATUS,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapTimerOnLine );
		//-------------------------------------------------------
		if(hDomePreBitmap!=NULL)
			{
			SendDlgItemMessage(G_DomePreID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hDomePreBitmap );
			}
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),DomeBmpName );
		hDomePreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		G_DomePreID=Y_CtrlID;
		//--------------------------------------------------
		if(Flag_PresetPropertySheet==1)
			PresetSheet->S_RefreshPresetName();
		//--------------------------------------------------
		//CComm::S_COM_FillPresetMaxSpeedToEE('\x08');
		break;
	/*
	case IDC_DOME_MORE :
		//if ( DomeNumOnBus<=8 )
		//	break;
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_DOME_MORED) );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		break;	
	*/
	//------------- Sequence --------------------------
	case IDC_SQ_DOME :
	case IDC_SQ_NUM1 :
	case IDC_SQ_NUM2 :
	case IDC_SQ_NUM3 :
	case IDC_SQ_NUM4 :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		SQNum=CSequence::S_SequenceIDToNum(Y_CtrlID,&SQBmpName);
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),SQBmpName );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		break;	
	//------------- Cruise --------------------------
	/*
	case IDC_CRUISE_DOME :
	case IDC_CRUISE_NUM1 :
	case IDC_CRUISE_NUM2 :
	case IDC_CRUISE_NUM3 :
	case IDC_CRUISE_NUM4 :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		CruiseNum=CCruise::S_CruiseIDToNum(Y_CtrlID,&CruiseBmpName);
		hBitmap=::LoadBitmap(AfxGetInstanceHandle(),CruiseBmpName );
		hPreBitmap=SendDlgItemMessage(Y_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmap );
		break;	
	*/
	//----------------------------------------------------------
	default	:
			G_CtrlID=NULL;
		break;
		}

 	}

	//-------------------------------------------------------------
	CDialog::OnLButtonDown(nFlags, point);
}


//###################################################################
// S_LButtonChoiceUp()
//
// Mouse left button released reaction
//###################################################################

void CControlDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
// TODO: Add your message handler code here and/or call default

//---------------------------------------
CPoint	Y_CPoint;
POINT	Y_Point;

Y_CPoint=point;
ClientToScreen(&Y_CPoint);
		Y_Point.x=Y_CPoint.x;
		Y_Point.y=Y_CPoint.y;
//hWnd_Child=::WindowFromPoint(Y_Point);
//---------------------------------------
if ( hPreBitmap != NULL )
	{
	SendDlgItemMessage(G_CtrlID,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,hPreBitmap );
	hPreBitmap=NULL;
	}

switch( G_CtrlID )
	{
	case IDC_RESET :
		//WinExec("vidcap.exe",SW_SHOW);
		//----
		CComm::S_COM_FillPresetMaxSpeedToEE('\x08');
		Sleep(1000);
		CComm::ResetDome();
		//----
		break;
	//--------------------- OSD --------------------------------
	case IDC_OSD :
	case IDC_OSD_LEFT :
	case IDC_OSD_UP :
	case IDC_OSD_RIGHT :
	case IDC_OSD_DOWN :
		CComm::S_COM_OSD_VKey(5);
		break;
	//-----------------------------------------------
	case IDC_VIDEO_IN	:
		//--------- Capture video ------------------------------
		if (VideoOn==0)
			{
			G_VideoMainCWnd->ShowWindow(SW_SHOW);
			//--------------------------------------------------
			RECT	rect;
			::GetWindowRect(G_VideoMainCWnd->m_hWnd,&rect);
			G_hWndVideo = capCreateCaptureWindow ( "Video", 
				WS_CHILD|WS_VISIBLE,
				0,0,rect.right-rect.left,rect.bottom-rect.top,
				G_VideoMainCWnd->m_hWnd, NULL);
			capDriverConnect (G_hWndVideo, 0);
			capOverlay(G_hWndVideo,TRUE);
			//--------------------------------------------------
			VideoOn=1;
			}
		else
			{
			capDriverDisconnect(G_hWndVideo);
			::DestroyWindow(G_hWndVideo);
			G_VideoMainCWnd->ShowWindow(SW_HIDE);
			VideoOn=0;
			}
		break;
	case IDC_COM_PORT :
		G_RCtrlID=G_CtrlID;
		::ReleaseCapture();

		CComm::S_GetSetting(ComPort,&AVL_NUM_DOME,&RTS);
		ComPort_Popup = ComPort_menu.GetSubMenu(0);
		UINT	ID;

		if( ComPort[3]=='1' )	ID=ID_MITEM_COM1;
		if( ComPort[3]=='2' )	ID=ID_MITEM_COM2;
		if( ComPort[3]=='3' )	ID=ID_MITEM_COM3;
		if( ComPort[3]=='4' )	ID=ID_MITEM_COM4;

		ComPort_Popup->CheckMenuItem(ID_MITEM_COM1,MF_UNCHECKED);
		ComPort_Popup->CheckMenuItem(ID_MITEM_COM2,MF_UNCHECKED);
		ComPort_Popup->CheckMenuItem(ID_MITEM_COM3,MF_UNCHECKED);
		ComPort_Popup->CheckMenuItem(ID_MITEM_COM4,MF_UNCHECKED);

		ComPort_Popup->CheckMenuItem(ID,MF_CHECKED);
		ComPort_Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			   Y_CPoint.x, Y_CPoint.y,AfxGetMainWnd());
		break;
	//--------------- IRIS Up/Down ------------------------
	case IDC_IRIS_OPEN  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		CComm::S_COM_IRISStop();
		break;
	case IDC_IRIS_CLOSE :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		CComm::S_COM_IRISStop();
		break;
	//--------------- Zoom in/out ------------------------
	case IDC_ZOOM_IN  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		CComm::S_COM_ZoomStop();
		break;
	case IDC_ZOOM_OUT  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		CComm::S_COM_ZoomStop();
		break;
	//--------------- Focus in/out -----------------------
	case IDC_FOCUS_IN  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		CComm::S_COM_FocusStop();
		break;
	case IDC_FOCUS_OUT  :
		if ( DomeEnable==0 )		//---- If dome is disconnect then disable
			break;
		CComm::S_COM_FocusStop();
		break;
	case IDC_AUTOFOCUS :
		CComm::S_COM_AutoFocus('\x01');
		break;
	//--------------- AutoFlip ---------------------------
	case IDC_AUTOFLIP :
		CComm::S_COM_AutoFlip();
		break;
	//--------------- Direction --------------------------
	case IDC_PAD	:
		switch(G_PadNum)
			{
			case 1:	CComm::S_COM_Manual();				//stop
					CComm::S_COM_PanStop();
					CComm::S_COM_TiltStop();
					break;								
			case 2:	//Sleep(1);	//-- Firmware don't response
					CComm::S_COM_PanStop();		break;	//left
			case 3:	CComm::S_COM_TiltStop();	break;	//up
			case 4:	//Sleep(1);							//right
					CComm::S_COM_PanStop();		break;	
			case 5:	CComm::S_COM_TiltStop();	break;	//down
			}
		PadDraw(0);
		break;
	//----- Sequence Cruise ------------------------------------
	case IDC_SQ_DOME :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		if (ManualFlag==1)	
			ManualFlag=0;
		CSequence::S_Sequence(1);
		break;
	case IDC_SQ_NUM1 :
	case IDC_SQ_NUM2 :
	case IDC_SQ_NUM3 :
	case IDC_SQ_NUM4 :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		G_RCtrlID=G_CtrlID;

		::SetCursor(LoadCursor(NULL, IDC_WAIT));
		//----- Indicate which SQ be pressed -------
		int Num;
			if(G_CtrlID==IDC_SQ_NUM1)	Num=1;
			if(G_CtrlID==IDC_SQ_NUM2)	Num=2;
			if(G_CtrlID==IDC_SQ_NUM3)	Num=3;
			if(G_CtrlID==IDC_SQ_NUM4)	Num=4;
		if (ManualFlag==1)	
			ManualFlag=0;
		CSequence::S_Sequence(Num);
		//------------------------------------------

		::SetCursor(LoadCursor(NULL, IDC_ARROW));
		break;
	//-------------- Cruise -----------------------------------
	/*
	case IDC_CRUISE_DOME :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		if (ManualFlag==1)	
			ManualFlag=0;
		CComm::S_COM_Cruise();
		break;
	case IDC_CRUISE_NUM1 :
	case IDC_CRUISE_NUM2 :
	case IDC_CRUISE_NUM3 :
	case IDC_CRUISE_NUM4 :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		//----- Read parameter from file to EE ----------
		::SetCursor(LoadCursor(NULL, IDC_WAIT));

		LPTSTR		CruiseBmpName;
		UINT		CruiseNum;
		CruiseNum=CCruise::S_CruiseIDToNum(G_CtrlID,&CruiseBmpName);
		CCruise::S_Cruise_ReadFileToEE(CruiseNum);
		//----- Command Dome to execute cruise ----------
		if (ManualFlag==1)	
			ManualFlag=0;
		CComm::S_COM_Cruise();
		//-----------------------------------------------
		::SetCursor(LoadCursor(NULL, IDC_ARROW));

		break;	
	*/
	//------------------------------------------------------
	/*
	case IDC_PRESET_MORE :
		{
		if( Flag_PresetPropertySheet==0 )
			{
			RECT	rect;
			//------- Create a modeless property page
			PresetSheet=new CPresetPropertySheet;
			PresetSheet->Create(AfxGetMainWnd(),
					WS_SYSMENU|WS_OVERLAPPED|WS_VISIBLE,WS_EX_DLGMODALFRAME);

			Flag_PresetPropertySheet=1;
			::GetWindowRect(PresetSheet->m_hWnd,&rect);
			::MoveWindow(PresetSheet->m_hWnd,0,450,
					rect.right-rect.left,rect.bottom-rect.top,1);
			}
		else
			{
			PresetSheet->EndDialog(0);
			Flag_PresetPropertySheet=0;
			}
		}
		break;
	*/
	//--------------------------
	/*
	case IDC_DOME_MORE :
		{
		if( Flag_DomePropertySheet==0 )
			{
			RECT	rect;
			//------- Create a modeless property page
			DomeSheet=new CDomePropertySheet;
			DomeSheet->Create(AfxGetMainWnd(),
					WS_SYSMENU|WS_OVERLAPPED|WS_VISIBLE,WS_EX_DLGMODALFRAME);

			Flag_DomePropertySheet=1;
			::GetWindowRect(DomeSheet->m_hWnd,&rect);
			::MoveWindow(DomeSheet->m_hWnd,0,425,
					rect.right-rect.left,rect.bottom-rect.top,1);

			//SetWindowPos(&wndNoTopMost,0,0,NULL,NULL,SWP_SHOWWINDOW);
			}
		else
			{
			DomeSheet->EndDialog(0);
			Flag_DomePropertySheet=0;
			}
		}
		break;	
	*/
	}

G_CtrlID=NULL;

//Polling=1;
	//-------------------------------------------------------------
	CDialog::OnLButtonUp(nFlags, point);
}



//###################################################################
// OnRButtonDown()
//
// Mouse right button pressed reaction
//###################################################################

void CControlDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
Flag_Polling=0;
// TODO: Add your message handler code here and/or call default
//---------------------------------------
int		Y_CtrlID;
CPoint	Y_CPoint;
POINT	Y_Point;
HWND	hWnd_Child;

Y_CPoint=point;
ClientToScreen(&Y_CPoint);
		Y_Point.x=Y_CPoint.x;
		Y_Point.y=Y_CPoint.y;
hWnd_Child=::WindowFromPoint(Y_Point);
//----------------------------------------

if ( hWnd_Child != m_hWnd )
	{
	Y_CtrlID=::GetDlgCtrlID( hWnd_Child ); 
	G_RCtrlID=Y_CtrlID;

	switch (Y_CtrlID)
		{
	case IDC_PRESET_NUM1 :
	case IDC_PRESET_NUM2 :
	case IDC_PRESET_NUM3 :
	case IDC_PRESET_NUM4 :
	case IDC_PRESET_NUM5 :
	case IDC_PRESET_NUM6 :
	case IDC_PRESET_NUM7 :
	case IDC_PRESET_NUM8 :
	case IDC_PRESET_NUM9 :
	case IDC_PRESET_NUM10:
	case IDC_PRESET_NUM11:
		if (DomeEnable==0)	//--- If dome is disconnect then disable
			break;
		::ReleaseCapture();
		PT_Popup = PT_menu.GetSubMenu(0);
		PT_Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
				   Y_CPoint.x, Y_CPoint.y, AfxGetMainWnd());
		break;
	//---------------------------
	case IDC_SQ_NUM1 :
	case IDC_SQ_NUM2 :
	case IDC_SQ_NUM3 :
	case IDC_SQ_NUM4 :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		::ReleaseCapture();
		SQ_Popup = SQ_menu.GetSubMenu(0);
		SQ_Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			   Y_Point.x, Y_Point.y, AfxGetMainWnd());
		break;
	/*
	case IDC_CRUISE_NUM1 :
	case IDC_CRUISE_NUM2 :
	case IDC_CRUISE_NUM3 :
	case IDC_CRUISE_NUM4 :
		if (DomeEnable==0)	//--- If dome is disconnect then disable 
			break;
		::ReleaseCapture();
		Cruise_Popup = Cruise_menu.GetSubMenu(0);
		Cruise_Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,
			   Y_Point.x, Y_Point.y, AfxGetMainWnd());
		break;	
	*/
		}
 	}
	
//----------------------------------------------------------
CDialog::OnRButtonDown(nFlags, point);
}



